/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LoggerTasklet;
import com.ibm.hwmca.fw.servlet.ServletAuthorized;
import com.ibm.hwmca.fw.servlet.logd.CachedData;
import com.ibm.hwmca.fw.servlet.logd.FileFn;
import com.ibm.hwmca.fw.servlet.logd.GetFileName;
import com.ibm.hwmca.fw.servlet.logd.GetRefcodeDesc;
import com.ibm.hwmca.fw.servlet.logd.HelpExpander;
import com.ibm.hwmca.fw.servlet.logd.LogDisplayerBlock;
import com.ibm.hwmca.fw.servlet.logd.LogDisplayerClassSelection;
import com.ibm.hwmca.fw.servlet.logd.LogDisplayerEvent;
import com.ibm.hwmca.fw.servlet.logd.LogServletMsg;
import com.ibm.hwmca.fw.servlet.logd.ReadNewLogFile;
import com.ibm.hwmca.fw.servlet.logd.ViewDataFileList;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogSummaryServlet
extends HttpServlet {
    private static final String TRACE_MASKT = "XLDSSUMT";
    private static final String TRACE_MASKF = "XLDSSUMF";
    private static final String TRACE_MASKD = "XLDSSUMD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String reqType = null;
        try {
            Trace.trace(TRACE_MASKF, "-> LogSummaryServlet.doGet");
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-cache");
            ServletRuntime.getRuntime().attachUserContextToServletThread(request);
            if (ServletAuthorized.isAuthorized(request, response, "base.task.xlds")) {
                reqType = request.getParameter("reqtype");
                if (reqType == null || reqType.length() == 0) {
                    reqType = "summary";
                }
                Trace.trace(TRACE_MASKF, "reqType=" + reqType);
                if ("summary".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Display the event log summary");
                    this.displaySummary(request, response);
                } else if ("refcodedesc".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Display the REFCODE");
                    this.displayRefcode(request, response);
                } else if ("logblock".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Display the list of block ids");
                    this.displayBlockIds(request, response);
                } else if ("logblockdata".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Display the log block data");
                    this.displayBlockData(request, response);
                } else if ("refresh".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Do the refresh");
                    this.doRefresh(request, response);
                } else if ("selbyclas".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Select by class");
                    this.selectByClass(request, response);
                } else if ("allclass".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Select all classes");
                    this.selectAllClasses(request, response);
                } else if ("selbyclasd".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Display log by selected class/es");
                    this.selectByClassDisplay(request, response);
                } else if ("purge".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Purge the log.");
                    this.purgeLog(request, response);
                } else if ("viewflist".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "View file list");
                    this.viewDataFileList(request, response);
                } else if ("zipit".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Zip files and save");
                    this.zipIt(request, response);
                } else if ("getfilename".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Get the log file name");
                    this.specifyLogFileName(request, response);
                } else if ("readnewfile".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Read new log file");
                    this.readNewLogFile(request, response);
                } else if ("help".equals(reqType)) {
                    Trace.trace(TRACE_MASKF, "Display help info");
                    this.doHelp(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "logdisp servlet Function not supported reqType=" + reqType);
                    LogServletMsg.displayMsg(request, response, "logd.eventsummary.title", "XLDSNSUP", MsgType.INFORMATION_MESSAGE);
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception caught from log servlet for reqtype=" + reqType);
            Trace.trace(TRACE_MASKF, exc);
            FrameworkLog log = new FrameworkLog(_logInfo, 2176, exc);
            if (reqType != null && reqType.length() != 0) {
                log.add(reqType);
            }
            log.log();
            LogServletMsg.displayMsg(request, response, "logd.eventsummary.title", "XLDSINER", MsgType.ERROR_MESSAGE);
        }
        Trace.trace(TRACE_MASKF, "<- LogSummaryServlet.doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trace.trace(TRACE_MASKF, "Into the post");
        this.doGet(request, response);
    }

    protected void displaySummary(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        LogDisplayerEvent.displayEvents(request, response, "summary", (short)2178);
    }

    protected void selectByClass(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        String logFileName = LogDisplayerEvent.getLogFileName(request);
        LogDisplayerClassSelection.displayClassList(request, response, logFileName);
    }

    protected void selectByClassDisplay(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> LogSummaryServlet.selectByClassDisplay()");
        String[] listClass = request.getParameterValues("listClass");
        Byte[] logClasses = null;
        if (listClass != null) {
            logClasses = new Byte[listClass.length];
            int classLen = listClass.length;
            for (int i = 0; i < classLen; ++i) {
                Integer iLogClass = Integer.valueOf(listClass[i], 16);
                byte bLogClass = iLogClass.byteValue();
                logClasses[i] = new Byte(bLogClass);
                Trace.trace(TRACE_MASKF, "logClassSELECTED =" + HexString.toHex(logClasses[i]));
            }
            LogDisplayerEvent.displayEvents(request, response, "selbyclasd", logClasses, (short)2189);
        } else {
            LogServletMsg.displayMsg(request, response, "logd.eventsummary.title", "XLDSNCLS", MsgType.INFORMATION_MESSAGE);
        }
        Trace.trace(TRACE_MASKF, "<- LogSummaryServlet.selectByClassDisplay()");
    }

    protected void selectAllClasses(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> LogSummaryServlet.selectAllClasses()");
        LogDisplayerEvent.displayEvents(request, response, "allclass", (short)2190);
        Trace.trace(TRACE_MASKF, "<- LogSummaryServlet.selectAllClasses()");
    }

    protected void doRefresh(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> LogSummaryServlet.doRefresh()");
        CachedData.clearCachedData();
        LogDisplayerEvent.displayEvents(request, response, "refresh", (short)2191);
        Trace.trace(TRACE_MASKF, "<- LogSummaryServlet.doRefresh()");
    }

    protected void purgeLog(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "-> LogSummaryServlet.purgeLog()");
        CachedData.clearCachedData();
        try {
            LoggerTasklet.purge("log");
            Trace.trace(TRACE_MASKF, "After purging the log. Now redisplay log");
            LogDisplayerEvent.displayEvents(request, response, "purge", (short)2188);
        }
        catch (HException hex) {
            Trace.trace(TRACE_MASKF, "Error from purge/redisplaying log function.");
            if (!hex.isLogged()) {
                FrameworkLog log = new FrameworkLog(_logInfo, 2183, hex);
                log.add("purge");
                log.log();
            }
            throw hex;
        }
        Trace.trace(TRACE_MASKF, "<- LogSummaryServlet.purgeLog()");
    }

    protected void displayRefcode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String refcode = request.getParameter("logdata");
        PrintWriter out = response.getWriter();
        String refcodeDesc = GetRefcodeDesc.getRefcodeDesc(refcode);
        GetRefcodeDesc.displayRefcodeDesc(out, refcodeDesc);
    }

    protected void viewDataFileList(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "->  LogSummaryServlet.viewFileList()");
        ViewDataFileList.displayFileList(request, response);
        Trace.trace(TRACE_MASKF, "<-  LogSummaryServlet.viewFileList()");
    }

    protected void zipIt(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "->  LogSummaryServlet.zipIt()");
        FileFn.createSendFileList(request, response);
        Trace.trace(TRACE_MASKF, "<-  LogSummaryServlet.zipIt()");
    }

    protected void displayBlockIds(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "->  LogSummaryServlet.displayBlockIds()");
        LogDisplayerBlock logBlock = new LogDisplayerBlock();
        logBlock.getDisplayBlocks(request, response);
        Trace.trace(TRACE_MASKF, "<- LogSummaryServlet.displayBlockIds()");
    }

    protected void displayBlockData(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "->  displayBlockData");
        LogDisplayerBlock logBlock = new LogDisplayerBlock();
        logBlock.displayBlockData(request, response);
        Trace.trace(TRACE_MASKF, "<- displayBlockData");
    }

    protected void specifyLogFileName(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "->  LogSummaryServlet.specifyLogFileName()");
        GetFileName.getFileName(request, response);
        Trace.trace(TRACE_MASKF, "<-  LogSummaryServlet.specifyLogFileName()");
    }

    protected void readNewLogFile(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "->  LogSummaryServlet.readLogFileName()");
        ReadNewLogFile.readNewLogFile(request, response);
        Trace.trace(TRACE_MASKF, "<-  LogSummaryServlet.readLogFileName()");
    }

    protected void doHelp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Trace.trace(TRACE_MASKF, "->  LogSummaryServlet.doHelp()");
        HelpExpander.displayHelp(request, response);
        Trace.trace(TRACE_MASKF, "<-  LogSummaryServlet.doHelp()");
    }
}

